#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#

%{!?configure_options: %define configure_options %{nil}}
%{!?configure_options32: %define configure_options32 %{nil}}

%ifarch %{ix86} ia64 ppc
%{!?_libdir: %define _libdir %{_prefix}/lib}
%else
%{!?_libdir: %define _libdir %{_prefix}/lib64}
%endif

%{!?build_32bit: %define build_32bit 0}
%{!?_libdir32: %define _libdir32 %{_prefix}/lib}
%{!?_libdir64: %define _libdir64 %{_prefix}/lib64}

%{!?CFLAGS: %define CFLAGS '-g -O2'}
%{!?CXXFLAGS: %define CXXFLAGS '-g -O2'}
%{!?LDFLAGS: %define LDFLAGS '-g -O2'}
%{!?FFLAGS: %define FFLAGS '-g -O2'}
%{!?flags32: %define flags32 '-m32 -g -O2 -L/usr/lib'}
%{!?ldflags32: %define ldflags32 '-m32 -g -O2 -L/usr/lib'}
%{!?flags_ppc64: %define flags_ppc64 '-m64 -g -O2'}
%{!?ldflags_ppc64: %define ldflags_ppc64 '-m64 -g -O2 -L/usr/lib64'}

%define build_srptools %(if ( echo "%{configure_options}" | grep -E "with-srptools|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ipoibtools %(if ( echo "%{configure_options}" | grep -E "with-ipoibtools|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_tvflash %(if ( echo "%{configure_options}  %{configure_options32}" | grep -E "with-tvflash" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libsdp %(if ( echo "%{configure_options}" | grep -E "with-libsdp|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_opensm %(if ( echo "%{configure_options}" | grep -E "with-opensm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libopensm %{build_opensm}
%define build_libopensm_devel %{build_opensm}
%define build_libosmcomp %{build_opensm}
%define build_libosmcomp_devel %{build_opensm}
%define build_libosmvendor %{build_opensm}
%define build_libosmvendor_devel %{build_opensm}

%define build_diags %(if ( echo "%{configure_options}" | grep -E "with-openib-diags|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_perftest %(if ( echo "%{configure_options}" | grep -E "with-perftest|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_mstflint %(if ( echo "%{configure_options} %{configure_options32}" | grep -E "with-mstflint|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_libibverbs %(if ( echo "%{configure_options}" | grep -E "with-libibverbs|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibverbs_devel %{build_libibverbs}
%define build_libibverbs_utils %{build_libibverbs}

%define build_libmthca %(if ( echo "%{configure_options}" | grep -E "with-libmthca|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libmthca_devel %{build_libmthca}

%define build_libmlx4 %(if ( echo "%{configure_options}" | grep -E "with-libmlx4|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libmlx4_devel %{build_libmlx4}

%define build_libehca %(if ( echo "%{configure_options}" | grep -E "with-libehca|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libehca_devel %{build_libehca}

%define build_libipathverbs %(if ( echo "%{configure_options}" | grep -E "with-libipathverbs|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libipathverbs_devel %{build_libipathverbs}

%define build_libibcm %(if ( echo "%{configure_options}" | grep -E "with-libibcm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibcm_devel %{build_libibcm}

%define build_libibcommon %(if ( echo "%{configure_options}" | grep -E "with-libibcommon|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibcommon_devel %{build_libibcommon}

%define build_libibmad %(if ( echo "%{configure_options}" | grep -E "with-libibmad|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibmad_devel %{build_libibmad}

%define build_libibumad %(if ( echo "%{configure_options}" | grep -E "with-libibumad|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibumad_devel %{build_libibumad}

%define build_librdmacm %(if ( echo "%{configure_options}" | grep -E "with-librdmacm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_librdmacm_devel %{build_librdmacm}
%define build_librdmacm_utils %{build_librdmacm}

%define build_dapl %(if ( echo "%{configure_options}" | grep -E "with-dapl|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_dapl_devel %{build_dapl}
%define build_dapl_utils %{build_dapl}

%define build_libcxgb3 %(if ( echo "%{configure_options}" | grep -E "with-libcxgb3|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libcxgb3_devel %{build_libcxgb3}

%define build_qlvnictools %(if ( echo "%{configure_options}" | grep -E "with-qlvnictools|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_sdpnetstat %(if ( echo "%{configure_options}" | grep -E "with-sdpnetstat|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define IB_CONF_DIR /etc/infiniband

# Disable debugging
%define debug_package %{nil}
%define __check_files %{nil}

# Disable brp-lib64-linux
%ifarch x86_64 ia64
%define __arch_install_post %{nil}
%endif

%define librdmacm_ver 1.0.2
%define libibcm_ver 1.0

%{!?_name: %define _name ofa_user}
%{!?_version: %define _version 1.2.c}
%{!?_release: %define _release 11}

Summary: Infiniband HCA Driver
Prereq: /sbin/ldconfig
Name: %{_name}
Version: %{_version}
Release: %{_release}
License: GPL/BSD
Url: http://www.openfabrics.org/
Group: System Environment/Base
Source: %{_name}-%{_version}.tgz
BuildRoot: %{?build_root:%{build_root}}%{!?build_root:/var/tmp/OFED}
Vendor: OpenFabrics
%description 
InfiniBand "verbs", Access Layer  and ULPs

%package -n libibverbs
Version: 1.1.1
Release: 0
Summary: A library for direct userspace use of InfiniBand
Group: System Environment/Libraries
%description -n libibverbs
libibverbs is a library that allows userspace processes to use
InfiniBand "verbs" as described in the InfiniBand Architecture
Specification.  This includes direct hardware access for fast path
operations.

%package -n libibverbs-devel
Version: 1.1.1
Release: 0
Summary: Development files for the libibverbs library
Group: System Environment/Libraries
%description -n libibverbs-devel
Static libraries and header files for the libibverbs verbs library.

%package -n libibverbs-utils
Version: 1.1.1
Release: 0
Summary: Examples for the libibverbs library
Group: System Environment/Libraries
%description -n libibverbs-utils
Useful libibverbs1 example programs such as ibv_devinfo, which
displays information about InfiniBand devices.

%package -n libibcm
Version: 1.0
Release: 1
Summary: Userspace InfiniBand Connection Manager.
Group: System Environment/Libraries
%description -n libibcm
Along with the OpenIB kernel drivers, libibcm provides a userspace
InfiniBand Connection Managment API.

%package -n libibcm-devel
Version: 1.0
Release: 1
Summary: Development files for the libibcm library
Group: System Environment/Libraries
%description -n libibcm-devel
Development files for the libibcm library.

%package -n libmthca
Version: 1.0.4
Release: 0
Summary: Mellanox InfiniBand HCA Userspace Driver
Group: System Environment/Libraries
%description -n libmthca
libmthca provides a device-specific userspace driver for Mellanox HCAs
(MT23108 InfiniHost and MT25208 InfiniHost III Ex) for use with the
libibverbs library.

%package -n libmthca-devel
Version: 1.0.4
Release: 0
Summary: Development files for the libmthca driver
Group: System Environment/Libraries
%description -n libmthca-devel
Static version of libmthca that may be linked directly to an
application, which may be useful for debugging.

%package -n libmlx4
Version: 0.1
Release: 0
Summary: Mellanox InfiniBand HCA Userspace Driver
Group: System Environment/Libraries
%description -n libmlx4
libmlx4 provides a device-specific userspace driver for Mellanox
ConnectX HCAs for use with the libibverbs library.

%package -n libmlx4-devel
Version: 0.1
Release: 0
Summary: Development files for the libmlx4 driver
Group: System Environment/Libraries
%description -n libmlx4-devel
Static version of libmlx4 that may be linked directly to an
application, which may be useful for debugging.

%package -n libcxgb3
Version: 1.0
Release: rc4
Summary: Chelsio T3 RNIC OpenIB Userspace Library
Group: System Environment/Libraries
%description -n libcxgb3
libcxgb3 provides a device-specific userspace driver for Chelsio RNICs
for use with the libibverbs library.

%package -n libcxgb3-devel
Version: 1.0
Release: rc4
Summary: Development files for the libcxgb3 driver
Group: System Environment/Libraries
%description -n libcxgb3-devel
Static version of libcxgb3 that may be linked directly to an
application, which may be useful for debugging.

%package -n libipathverbs
Version: 1.1
Release: 0
Summary: PathScale InfiniPath HCA Userspace Driver
Group: System Environment/Libraries
%description -n libipathverbs
libipathverbs provides a device-specific userspace driver for PathScale HCAs.

%package -n libipathverbs-devel
Version: 1.1
Release: 0
Summary: Development files for the libipathverbs driver
Group: System Environment/Libraries
%description -n libipathverbs-devel
Static version of libipathverbs that may be linked directly to an
application, which may be useful for debugging.

%package -n libehca
Version: 1.0
Release: 0
Summary: IBM eServer eHCA Infiniband device driver for Linux on POWER
Group: System Environment/Libraries
%description -n libehca
IBM eServer eHCA Infiniband device driver for Linux on POWER

%package -n libehca-devel
Version: 1.0
Release: 0
Summary: Development files for the libehca driver
Group: System Environment/Libraries
%description -n libehca-devel
Static version of libehca that may be linked directly to an
application, which may be useful for debugging.

%package -n libsdp
Version: 1.1.99
Release: 0
Summary: LD_PRELOAD-able library for using SDP
Group: System Environment/Libraries
%description -n libsdp
libsdp can be LD_PRELOAD-ed to have a sockets application use
InfiniBand Sockets Direct Protocol (SDP) instead of TCP, transparently
and without recompiling the application.

%package -n sdpnetstat
Version: 1.50
Release: 1
Summary: netstat for SDP
Group: Applications/System
%description -n sdpnetstat
netstat for SDP

%package -n srptools
Version: 0.0.4
Release: 0
Summary: Tools for SRP/IB
Group: Applications/System
%description -n srptools
In conjunction with the kernel ib_srp driver, srptools allows you to
discover and use SCSI devices via the SCSI RDMA Protocol over InfiniBand.

%package -n ipoibtools
Version: 1.1
Release: 0
Summary: IPoIB High Availability daemon
Group: Applications/System
%description -n ipoibtools
IPoIB High Availability daemon

%package -n tvflash
Version: 0.9.0
Release: 0
Summary: Tool to manage Mellanox HCA firmware flash memory
Group: Applications/System
%description -n tvflash
tvflash is used to query and update the firmware flash memory attached
to Mellanox InfiniBand HCAs.

%package -n libibcommon
Version: 1.0.4
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibcommon
libibcommon provides common utility functions for the IB diagnostic and
management tools.

%package -n libibcommon-devel
Version: 1.0.4
Release: 0
Summary: Development files for the libibcommon library
Group: System Environment/Libraries
%description -n libibcommon-devel
Development files for the libibcommon library

%package -n libibmad
Version: 1.0.6
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibmad
libibmad provides low layer IB functions for use by the IB diagnostic
and management programs. These include MAD, SA, SMP, and other basic
IB functions.

%package -n libibmad-devel
Version: 1.0.6
Release: 0
Summary: Development files for the libibmad library.
Group: System Environment/Libraries
%description -n libibmad-devel
Development files for the libibmad library.

%package -n libibumad
Version: 1.0.6
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibumad
libibumad provides the user MAD library functions which sit on top of
the user MAD modules in the kernel. These are used by the IB diagnostic
and management tools, including OpenSM.

%package -n libibumad-devel
Version: 1.0.6
Release: 0
Summary: Development files for the libibumad library.
Group: System Environment/Libraries
%description -n libibumad-devel
Development files for the libibumad library.

%package -n openib-diags
Version: 1.2.7
Release: 0
Summary: OpenIB InfiniBand Diagnostic Tools
Group: System Environment/Libraries
Provides: perl(IBswcountlimits)
%description -n openib-diags
diags provides IB diagnostic programs and scripts needed to diagnose
an IB subnet.

%package -n libosmcomp
Version: 3.0.3
Release: 0
Summary: OpenSM component library
Group: System Environment/Libraries
%description -n libosmcomp
libosmcomp provides the OS component library for OpenSM.

%package -n libosmcomp-devel
Version: 3.0.3
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n libosmcomp-devel
Static component libraries for OpenSM.

%package -n libopensm
Version: 3.0.3
Release: 0
Summary: OpenSM libraries
Group: System Environment/Libraries
%description -n libopensm
libopensm provides the library for OpenSM.

%package -n libopensm-devel
Version: 3.0.3
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n libopensm-devel
Static component libraries for OpenSM.

%package -n libosmvendor
Version: 3.0.3
Release: 0
Summary: OpenSM vendor library
Group: System Environment/Libraries
%description -n libosmvendor
libosmvendor provides the vendor library for OpenSM.

%package -n libosmvendor-devel
Version: 3.0.3
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n libosmvendor-devel
Static vendor libraries for OpenSM.

%package -n opensm
Version: 3.0.3
Release: 0
Summary: InfiniBand subnet manager and administration
Group: System Environment/Libraries
%description -n opensm
OpenSM provides an implementation for an InfiniBand Subnet Manager and
Administration. Such a software entity is required to run for in order
to initialize the InfiniBand hardware (at least one per each
InfiniBand subnet).

%package -n perftest
Version: 1.2
Release: 0
Summary: IB Performance tests
Group: System Environment/Libraries
%description -n perftest
gen2 uverbs microbenchmarks

%package -n mstflint
Version: 1.2
Release: 0
Summary: Burning Firmware Application
Group:  Applications/System
%description -n mstflint
This package contains a burning tool for Mellanox manufactured HCA cards.
It also provides access to the relevant source code.

%package -n librdmacm
Version: 1.0.2
Release: 0
Summary: Userspace RDMA Connection Manager.
Group:  System Environment/Libraries
%description -n librdmacm
RDMA cm library.

%package -n librdmacm-devel
Version: 1.0.2
Release: 0
Summary: Development files for the librdmacm library
Group:  System Environment/Libraries
%description -n librdmacm-devel
Development files for the librdmacm library.

%package -n librdmacm-utils
Version: 1.0.2
Release: 0
Summary: Utilities for the librdmacm library
Group:  System Environment/Base
%description -n librdmacm-utils
Utilities for the librdmacm library.

%package -n dapl
Version: 1.2.1
Release: 0
Summary: Userspace DAT and DAPL API.
Group:  System Environment/Libraries
%description -n dapl
Along with the OpenIB kernel drivers, libdat and libdapl provides a userspace
RDMA API that supports DAT 1.2 specification

%package -n dapl-devel
Version: 1.2.1
Release: 0
Summary: Development files for the libdat and libdapl libraries
Group:  System Environment/Libraries
%description -n dapl-devel
Static libraries and header files for the libdat and libdapl library.

%package -n dapl-utils
Version: 1.2.1
Release: 0
Summary: Test suites for uDAPL library
Group:  System Environment/Libraries
%description -n dapl-utils
Useful test suites to validate uDAPL library API's.

%package -n qlvnictools
Version: 0.0.1
Release: 0
Summary: Tools for VNIC/IB
Group: Applications/System
%description -n qlvnictools
In conjunction with the kernel ib_vnic driver, ibvexdmtools allows you to
discover and use QLogic Virtual NIC devices via the VNIC protocol over InfiniBand.

#################################################################################################################################


%prep
%setup -n %{_name}-%{_version}

###
### install
###
%install
cd $RPM_BUILD_DIR/%{_name}-%{_version}

install -d $RPM_BUILD_ROOT/etc/init.d
install -d $RPM_BUILD_ROOT/%{_sysconfdir}

# Save clean sources
install -d $RPM_BUILD_ROOT/%{_prefix}/src
cp -a $RPM_BUILD_DIR/%{_name}-%{_version} $RPM_BUILD_ROOT/%{_prefix}/src

%ifarch ppc64
env CFLAGS=%{flags_ppc64} CXXFLAGS=%{flags_ppc64} LDFLAGS=%{ldflags_ppc64} FFLAGS=%{flags_ppc64} \
./configure --prefix=%{_prefix} --libdir=%{_libdir64} %{configure_options}
%else
./configure --prefix=%{_prefix} --libdir=%{_libdir} %{configure_options}
%endif

%ifarch ppc64
    %if %{build_perftest}
        make perftest LDLIBS='-m64 -g -O2 -L/usr/lib64'
    %endif
    make user WITH_PERFTEST=no
%else
    make user
%endif
make DESTDIR=$RPM_BUILD_ROOT install_user

%ifarch x86_64 ppc64
    %if %{build_32bit}
        # Backup 64 bit binaries
        if [ -d $RPM_BUILD_ROOT%{_prefix}/bin ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/bin $RPM_BUILD_ROOT%{_prefix}/bin64
        fi
        if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/sbin $RPM_BUILD_ROOT%{_prefix}/sbin64
        fi
        # dirs=$(find $RPM_BUILD_DIR/%{_name}-%{_version}/src/userspace  -maxdepth 2 -name Makefile -exec dirname '{}' ';')
        dirs=$(find $RPM_BUILD_DIR/%{_name}-%{_version}/src/userspace -name Makefile -exec dirname '{}' ';')
        for dd in $dirs; do if ! ( make clean -C $dd ); then continue; fi; done
        env CFLAGS=%{flags32} CXXFLAGS=%{flags32} LDFLAGS=%{ldflags32} FFLAGS=%{flags32} \
        ./configure --prefix=%{_prefix} --libdir=%{_libdir32} --without-patch %{configure_options32}
        make user
        make DESTDIR=$RPM_BUILD_ROOT install_user

	%ifarch x86_64
	        # Backup 32 bit binaries
                if [ -d $RPM_BUILD_ROOT%{_prefix}/bin ]; then
                    mv $RPM_BUILD_ROOT%{_prefix}/bin $RPM_BUILD_ROOT%{_prefix}/bin32
                fi
                if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin ]; then
                    mv $RPM_BUILD_ROOT%{_prefix}/sbin $RPM_BUILD_ROOT%{_prefix}/sbin32
                fi
                # Restore 64 bit binaries
                if [ -d $RPM_BUILD_ROOT%{_prefix}/bin64 ]; then
                    mv $RPM_BUILD_ROOT%{_prefix}/bin64 $RPM_BUILD_ROOT%{_prefix}/bin
                fi
                if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin64 ]; then
                    mv $RPM_BUILD_ROOT%{_prefix}/sbin64 $RPM_BUILD_ROOT%{_prefix}/sbin
                fi
	%endif
        
        %ifarch ppc64
                # Copy 64 bit binaries to the bin directory
                # Do not override 32 bit binaries
                if [ -d $RPM_BUILD_ROOT%{_prefix}/bin64 ]; then
                    install -d $RPM_BUILD_ROOT%{_prefix}/bin
                    for bb in $(/bin/ls $RPM_BUILD_ROOT%{_prefix}/bin64)
                    do
                        # Use opensm 64 bit binary on ppc64
                        if [ ! -f $RPM_BUILD_ROOT%{_prefix}/bin/${bb} ] || [ "${bb}" == "opensm" ]; then
                            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin64/${bb} $RPM_BUILD_ROOT%{_prefix}/bin
                        fi
                    done
                fi
                if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin64 ]; then
                    install -d $RPM_BUILD_ROOT%{_prefix}/sbin
                    for bb in $(/bin/ls $RPM_BUILD_ROOT%{_prefix}/sbin64)
                    do
                        if [ ! -f $RPM_BUILD_ROOT%{_prefix}/sbin/${bb} ]; then
                            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/sbin64/${bb} $RPM_BUILD_ROOT%{_prefix}/sbin
                        fi
                    done
                fi
	%endif

        if [ -f $RPM_BUILD_ROOT%{_prefix}/sbin32/tvflash ] && [ ! -f $RPM_BUILD_ROOT%{_prefix}/sbin/tvflash ]; then
            mkdir -p $RPM_BUILD_ROOT%{_prefix}/sbin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/sbin32/tvflash $RPM_BUILD_ROOT%{_prefix}/sbin/tvflash
        fi
        if [ -f $RPM_BUILD_ROOT%{_prefix}/bin32/mstflint ] && [ ! -f $RPM_BUILD_ROOT%{_prefix}/bin/mstflint ]; then
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mstflint $RPM_BUILD_ROOT%{_prefix}/bin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mstmread $RPM_BUILD_ROOT%{_prefix}/bin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mstmwrite $RPM_BUILD_ROOT%{_prefix}/bin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mstvpd $RPM_BUILD_ROOT%{_prefix}/bin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mstregdump $RPM_BUILD_ROOT%{_prefix}/bin
        fi
    %endif
%endif
	

INFO=${RPM_BUILD_ROOT}%{IB_CONF_DIR}/info
/bin/rm -f ${INFO}
mkdir -p ${RPM_BUILD_ROOT}%{IB_CONF_DIR}
touch ${INFO}

cat >> ${INFO} << EOFINFO
#!/bin/bash

echo prefix=%{_prefix}
echo
echo "Configure options: %{configure_options}"
echo
EOFINFO

chmod +x ${INFO} > /dev/null 2>&1


##     # Handle 32 bit libraries
touch libsdp-files
touch libibverbs-files
touch libibverbs-devel-files
touch libibcm-files
touch libibcm-devel-files
touch librdmacm-files
touch librdmacm-devel-files
touch dapl-files
touch dapl-devel-files
touch libmthca-files
touch libmthca-devel-files
touch libmlx4-files
touch libmlx4-devel-files
touch libcxgb3-files
touch libcxgb3-devel-files
touch libipathverbs-files
touch libipathverbs-devel-files
touch libehca-files
touch libehca-devel-files
touch libibcommon-files
touch libibcommon-devel-files
touch libibmad-files
touch libibmad-devel-files
touch libibumad-files
touch libibumad-devel-files
touch libopensm-files
touch libopensm-devel-files
touch libosmcomp-files
touch libosmcomp-devel-files
touch libosmvendor-files
touch libosmvendor-devel-files


%if %{build_libibcm}
    cd $RPM_BUILD_ROOT%{_libdir}
    if [ -f libibcm.so ]; then
        mv libibcm.so libibcm.so.%{libibcm_ver}
        ln -s libibcm.so.%{libibcm_ver} libibcm.so
    fi
    if [ "%{_libdir}" != "%{_libdir32}" ]; then
        if [ -d $RPM_BUILD_ROOT%{_libdir32} ]; then
            cd $RPM_BUILD_ROOT%{_libdir32}
            if [ -f libibcm.so ]; then
                mv libibcm.so libibcm.so.%{libibcm_ver}
                ln -s libibcm.so.%{libibcm_ver} libibcm.so
            fi
        fi
    fi
    cd $RPM_BUILD_DIR/%{_name}-%{_version}
%endif

%if %{build_librdmacm}
    cd $RPM_BUILD_ROOT%{_libdir}
    if [ -f librdmacm.so ]; then
        mv librdmacm.so librdmacm.so.%{librdmacm_ver}
        ln -s librdmacm.so.%{librdmacm_ver} librdmacm.so
    fi
    if [ "%{_libdir}" != "%{_libdir32}" ]; then
        if [ -d $RPM_BUILD_ROOT%{_libdir32} ]; then
            cd $RPM_BUILD_ROOT%{_libdir32}
            if [ -f librdmacm.so ]; then
                mv librdmacm.so librdmacm.so.%{librdmacm_ver}
                ln -s librdmacm.so.%{librdmacm_ver} librdmacm.so
            fi
        fi
    fi
    cd $RPM_BUILD_DIR/%{_name}-%{_version}
%endif

%ifarch x86_64 ppc64
    %if %{build_32bit}
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibverbs-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibverbs-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibverbs*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibverbs*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibverbs-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcm*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcm*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcm-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcm*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcm*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcm-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcm*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcm*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibcm-devel-files
        fi
        # Remove 32 bit libsdp_sys libraries from 'prefix'/lib directory
        /bin/rm -f $RPM_BUILD_ROOT%{_libdir32}/libsdp_sys*so*
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libsdp*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libsdp*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libsdp-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > librdmacm-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so | sed -e "s@$RPM_BUILD_ROOT@@g" > librdmacm-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/librdmacm*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/librdmacm*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> librdmacm-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libda*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libda*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > dapl-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libda*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libda*so | sed -e "s@$RPM_BUILD_ROOT@@g" > dapl-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libda*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libda*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> dapl-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libmthca*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libmthca*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libmthca-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libmthca*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libmthca*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libmthca-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libmlx4*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libmlx4*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libmlx4-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libmlx4*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libmlx4*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libmlx4-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libcxgb3*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libcxgb3*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libcxgb3-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libcxgb3*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libcxgb3*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libcxgb3-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libipathverbs*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libipathverbs*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libipathverbs-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libipathverbs*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libipathverbs*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libipathverbs-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libehca*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libehca*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libehca-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libehca*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libehca*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libehca-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcommon-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcommon-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcommon*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcommon*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibcommon-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibmad*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibmad*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibmad-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibmad*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibmad*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibmad-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibmad*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibmad*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibmad-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibumad*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibumad*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibumad-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibumad*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibumad*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibumad-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibumad*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibumad*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibumad-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libopensm*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libopensm*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libopensm-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libopensm*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libopensm*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libopensm-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libopensm*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libopensm*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libopensm-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmcomp-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmcomp-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libosmcomp-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmvendor-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmvendor-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libosmvendor-devel-files
        fi

    %endif
%endif

# Copy infiniband configuration
install -d $RPM_BUILD_ROOT/%{IB_CONF_DIR}
touch $RPM_BUILD_ROOT/%{IB_CONF_DIR}/openib.conf

%if %{build_libibverbs}
install -d $RPM_BUILD_ROOT/etc/ld.so.conf.d
echo %{_libdir} > $RPM_BUILD_ROOT/etc/ld.so.conf.d/ofed.conf
    %ifarch x86_64 ppc64
    echo %{_libdir32} >> $RPM_BUILD_ROOT/etc/ld.so.conf.d/ofed.conf
    %endif
case %{_prefix} in
	/usr | /usr/)
	;;
	*)
	echo "/etc/ld.so.conf.d/ofed.conf" >> libibverbs-files
	;;
esac
%endif

%if %{build_libibverbs_utils}
install -d $RPM_BUILD_ROOT/etc/profile.d
cat > $RPM_BUILD_ROOT/etc/profile.d/ofed.sh << EOF
if ! echo \${PATH} | grep -q %{_prefix}/bin ; then
        PATH=\${PATH}:%{_prefix}/bin
fi
if ! echo \${PATH} | grep -q %{_prefix}/sbin ; then
        PATH=\${PATH}:%{_prefix}/sbin
fi
if ! echo \${MANPATH} | grep -q %{_mandir} ; then
        MANPATH=\${MANPATH}:%{_mandir}
fi
EOF
cat > $RPM_BUILD_ROOT/etc/profile.d/ofed.csh << EOF
if (\$?path) then
if ( "\${path}" !~ *%{_prefix}/bin* ) then
        set path = ( \$path %{_prefix}/bin )
endif
if ( "\${path}" !~ *%{_prefix}/sbin* ) then
        set path = ( \$path %{_prefix}/sbin )
endif
else
        set path = ( %{_prefix}/bin %{_prefix}/sbin )
endif
if (\$?MANPATH) then
if ( "\${MANPATH}" !~ *%{_mandir}* ) then
        setenv MANPATH \${MANPATH}:%{_mandir}
endif
else
        setenv MANPATH %{_mandir}:
endif
EOF
%endif

%if %{build_dapl}
# udapl configuration file
perl -ni -e  "s@/usr/lib@%{_libdir}@;print" $RPM_BUILD_ROOT/%{_sysconfdir}/dat.conf
%endif

%if %{build_opensm}
# Install openib service script
install -m 0644 $RPM_BUILD_DIR/%{_name}-%{_version}/ofed_scripts/opensm.conf $RPM_BUILD_ROOT/etc/opensm.conf
install -m 0755 $RPM_BUILD_DIR/%{_name}-%{_version}/ofed_scripts/opensmd $RPM_BUILD_ROOT/etc/init.d/opensmd

# Add sldd.sh (W/A for handover issue)

install -m 0755 $RPM_BUILD_DIR/%{_name}-%{_version}/ofed_scripts/sldd.sh $RPM_BUILD_ROOT/%{_prefix}/bin/sldd.sh
sed -i -e "s@/usr/bin/opensm@%{_prefix}/bin/opensm@g" $RPM_BUILD_ROOT/etc/init.d/opensmd
sed -i -e "s@/usr/bin/sldd.sh@%{_prefix}/bin/sldd.sh@g" $RPM_BUILD_ROOT/etc/init.d/opensmd
%endif

%clean
#Remove installed driver after rpm build finished
# Leave $RPM_BUILD_ROOT in order to build dependent packages
rm -rf $RPM_BUILD_DIR/%{_name}-%{_version}

###
### pre section
###

###
### post section
###
%post -n libibverbs
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibverbs-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibverbs-utils
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibcm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libmthca
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libmthca-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libmlx4
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libmlx4-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libcxgb3
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libcxgb3-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libehca
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libehca-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libipathverbs
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libipathverbs-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libsdp
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibcommon
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibcommon-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibmad
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibmad-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibumad
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibumad-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmcomp
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmcomp-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmvendor
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmvendor-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libopensm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi


%post -n ipoibtools
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    if [ -e %{IB_CONF_DIR}/openib.conf ]; then
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Enable IPoIB High Availability daemon" >> %{IB_CONF_DIR}/openib.conf
       echo "IPOIBHA_ENABLE=no" >> %{IB_CONF_DIR}/openib.conf
       echo "# PRIMARY_IPOIB_DEV=ib0" >> %{IB_CONF_DIR}/openib.conf
       echo "# SECONDARY_IPOIB_DEV=ib1" >> %{IB_CONF_DIR}/openib.conf
    fi
fi

%post -n srptools
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    if [ -e %{IB_CONF_DIR}/openib.conf ]; then
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Enable SRP High Availability daemon" >> %{IB_CONF_DIR}/openib.conf
       echo "SRPHA_ENABLE=no" >> %{IB_CONF_DIR}/openib.conf
    fi
fi

%post -n libopensm-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n opensm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
#
# Bring up/down opensm
#
# chkconfig: 235 40 80
# description: Activates/Deactivates all OpenSM to \
#              start at boot time.
#
### BEGIN INIT INFO
# Provides:       opensmd
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/opensmd

        if ! ( /sbin/chkconfig --del opensmd > /dev/null 2>&1 ); then
                true
        fi
        if ! ( /sbin/chkconfig --add opensmd > /dev/null 2>&1 ); then
                true
        fi
fi

if [ -f /etc/SuSE-release ]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
### BEGIN INIT INFO
# Provides:       opensmd
# Required-Start: $network openibd
# Required-Stop:
# Default-Start:  2 3 5
# Default-Stop: 0 1 2 6
# Description:    Activates/Deactivates OpenSM to \
#                 start at boot time.
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/opensmd

        if ! ( /sbin/insserv opensmd > /dev/null 2>&1 ); then
                true
        fi
fi

fi # 1 : Closed

%post -n librdmacm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n dapl
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n dapl-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

###
### preun section
###
%preun -n opensm
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
         if ! ( /sbin/chkconfig --del opensmd > /dev/null 2>&1 ); then
                true
         fi
    fi
    if [ -f /etc/SuSE-release ]; then
         if ! ( /sbin/insserv -r opensmd > /dev/null 2>&1 ); then
                true
         fi
    fi
fi

###
### post uninstall section
###
%postun -n libibverbs
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    /sbin/ldconfig        
fi



###
### Files
###
%if %{build_libibverbs}
%files -n libibverbs -f libibverbs-files
%defattr(-,root,root,-)
%{_libdir}/libibverbs*.so.*
%endif

%if %{build_libibverbs_devel}
%files -n libibverbs-devel -f libibverbs-devel-files
%defattr(-,root,root,-)
%{_libdir}/libibverbs*.a
%{_libdir}/libibverbs*.so
%{_prefix}/include/infiniband/arch.h         
%{_prefix}/include/infiniband/driver.h       
%{_prefix}/include/infiniband/kern-abi.h     
%{_prefix}/include/infiniband/marshall.h     
%{_prefix}/include/infiniband/opcode.h       
%{_prefix}/include/infiniband/sa.h           
%{_prefix}/include/infiniband/sa-kern-abi.h  
%{_prefix}/include/infiniband/verbs.h
%{_mandir}/man3/ibv_*
%{_mandir}/man3/mult_to_ibv_rate*
#%{_includedir}/*
%endif

%if %{build_libibverbs_utils}
%files -n libibverbs-utils
%defattr(-,root,root,-)
# %{_bindir}/*
%{_prefix}/bin/ibv_*
%{_mandir}/man1/ibv_*
/etc/profile.d/ofed.sh
/etc/profile.d/ofed.csh
%endif

%if %{build_libibcm}
%files -n libibcm -f libibcm-files
%defattr(-,root,root,-)
%{_libdir}/libibcm*.so.*
%endif

%if %{build_libibcm_devel}
%files -n libibcm-devel -f libibcm-devel-files
%defattr(-,root,root,-)
%{_libdir}/libibcm*.so
%{_prefix}/include/infiniband/cm_abi.h
%{_prefix}/include/infiniband/cm.h
%endif

%if %{build_libmthca}
%files -n libmthca -f libmthca-files
%defattr(-,root,root,-)
%{_libdir}/libmthca*.so
%{_sysconfdir}/libibverbs.d/mthca.driver
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libmthca_devel}
%files -n libmthca-devel -f libmthca-devel-files
%defattr(-,root,root,-)
%{_libdir}/libmthca.a
%endif

%if %{build_libmlx4}
%files -n libmlx4 -f libmlx4-files
%defattr(-,root,root,-)
%{_libdir}/libmlx4*.so
%{_sysconfdir}/libibverbs.d/mlx4.driver
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libmlx4_devel}
%files -n libmlx4-devel -f libmlx4-devel-files
%defattr(-,root,root,-)
%{_libdir}/libmlx4.a
%endif

%if %{build_libipathverbs}
%files -n libipathverbs -f libipathverbs-files
%defattr(-,root,root,-)
%{_libdir}/libipathverbs*.so
%{_sysconfdir}/libibverbs.d/ipath.driver
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libipathverbs_devel}
%files -n libipathverbs-devel -f libipathverbs-devel-files
%defattr(-,root,root,-)
%{_libdir}/libipathverbs.a
%endif

%if %{build_libehca}
%files -n libehca -f libehca-files
%defattr(-,root,root,-)
%{_libdir}/libehca*.so*
%{_sysconfdir}/libibverbs.d/ehca.driver
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libehca_devel}
%files -n libehca-devel -f libehca-devel-files
%defattr(-,root,root,-)
%{_libdir}/libehca*.a
%endif

%if %{build_libsdp}
%files -n libsdp -f libsdp-files
%defattr(-,root,root)
%{_libdir}/libsdp*.so*
#%config(noreplace) %{_sysconfdir}/libsdp.conf
%{_sysconfdir}/libsdp.conf
%endif

%if %{build_srptools}
%files -n srptools
%defattr(-,root,root)
%{_prefix}/sbin/ibsrpdm
%{_prefix}/sbin/srp_daemon
%{_prefix}/sbin/srp_daemon.sh
%{_prefix}/sbin/run_srp_daemon
%{_mandir}/man1/ibsrpdm.1* 
%{_mandir}/man1/srp_daemon.1*
%config(noreplace) /etc/srp_daemon.conf
%endif

%if %{build_ipoibtools}
%files -n ipoibtools
%defattr(-,root,root)
%{_prefix}/bin/mcasthandle
%{_prefix}/bin/ipoib_ha.pl
%{_prefix}/sbin/ha
%{_prefix}/sbin/ipoibarping
%endif

%if %{build_tvflash}
%files -n tvflash
%defattr(-,root,root)
%{_prefix}/sbin/tvflash
%endif

%if %{build_libibcommon}
%files -n libibcommon -f libibcommon-files
%defattr(-,root,root)
%{_libdir}/libibcommon*.so.*
%endif

%if %{build_libibcommon_devel}
%files -n libibcommon-devel -f libibcommon-devel-files
%defattr(-,root,root)
%{_libdir}/libibcommon.a
%{_libdir}/libibcommon*.so
%{_prefix}/include/infiniband/common.h
%endif

%if %{build_libibmad}                     
%files -n libibmad -f libibmad-files
%defattr(-,root,root)
%{_libdir}/libibmad*.so.*
%endif

%if %{build_libibmad_devel}
%files -n libibmad-devel -f libibmad-devel-files
%defattr(-,root,root)
%{_libdir}/libibmad.a
%{_libdir}/libibmad.so
%{_prefix}/include/infiniband/mad.h
%endif

%if %{build_libibumad}                
%files -n libibumad -f libibumad-files
%defattr(-,root,root)
%{_libdir}/libibumad*.so.*
%endif

%if %{build_libibumad_devel}
%files -n libibumad-devel -f libibumad-devel-files
%defattr(-,root,root)
%{_libdir}/libibumad.so
%{_libdir}/libibumad.a
%{_prefix}/include/infiniband/umad.h
%{_mandir}/man3/umad_*
%endif

%if %{build_diags}
%files -n openib-diags
%defattr(-,root,root)
%{_prefix}/bin/ibaddr 
%{_prefix}/bin/ibnetdiscover 
%{_prefix}/bin/ibping 
%{_prefix}/bin/ibroute 
%{_prefix}/bin/ibstat 
%{_prefix}/bin/ibsysstat 
%{_prefix}/bin/ibtracert 
%{_prefix}/bin/perfquery 
%{_prefix}/bin/sminfo 
%{_prefix}/bin/smpquery 
%{_prefix}/bin/saquery 
%{_prefix}/bin/smpdump
%{_prefix}/bin/ibchecknet
%{_prefix}/bin/ibchecknode
%{_prefix}/bin/ibcheckerrors
%{_prefix}/bin/ibcheckport
%{_prefix}/bin/ibhosts
%{_prefix}/bin/ibstatus 
%{_prefix}/bin/ibswitches
%{_prefix}/bin/ibdiscover.pl
%{_prefix}/bin/ibswportwatch.pl
%{_prefix}/bin/dump_lfts.sh
%{_prefix}/bin/ibcheckerrs
%{_prefix}/bin/ibcheckportstate
%{_prefix}/bin/ibcheckportwidth
%{_prefix}/bin/ibcheckstate
%{_prefix}/bin/ibcheckwidth
%{_prefix}/bin/ibclearcounters
%{_prefix}/bin/ibclearerrors
%{_prefix}/bin/ibnodes
%{_prefix}/bin/ibportstate
%{_prefix}/bin/vendstat
%{_prefix}/lib/perl/IBswcountlimits.pm
%{_mandir}/man8/ib*
%{_mandir}/man8/sm*
%{_mandir}/man8/dump_lfts*
%{_mandir}/man8/dump_mfts*
%{_mandir}/man8/vendstat*
%{_prefix}/bin/ibqueryerrors.pl
%{_prefix}/bin/ibprintswitch.pl
%{_prefix}/bin/ibprintca.pl
%{_prefix}/bin/iblinkinfo.pl
%{_prefix}/bin/ibfindnodesusing.pl
%{_prefix}/bin/dump_mfts.sh
%endif

%if %{build_libosmcomp}
%files -n libosmcomp -f libosmcomp-files
%defattr(-,root,root)
%{_libdir}/libosmcomp*.so.*
%endif

%if %{build_libosmcomp_devel}
%files -n libosmcomp-devel -f libosmcomp-devel-files
%defattr(-,root,root)
%{_libdir}/libosmcomp*.so
%{_libdir}/libosmcomp*.a
%{_prefix}/include/infiniband/complib
%endif

%if %{build_libosmvendor}
%files -n libosmvendor -f libosmvendor-files
%defattr(-,root,root)
%{_libdir}/libosmvendor*.so.*
%endif

%if %{build_libosmvendor_devel}
%files -n libosmvendor-devel -f libosmvendor-devel-files
%defattr(-,root,root)
%{_libdir}/libosmvendor*.so
%{_libdir}/libosmvendor*.a
%{_prefix}/include/infiniband/vendor
%endif

%if %{build_libopensm}
%files -n libopensm -f libopensm-files
%defattr(-,root,root)
%{_libdir}/libopensm*.so.*
%endif

%if %{build_libopensm_devel}
%files -n libopensm-devel -f libopensm-devel-files
%defattr(-,root,root)
%{_libdir}/libopensm*.so
%{_libdir}/libopensm*.a
%{_prefix}/include/infiniband/opensm
%{_prefix}/include/infiniband/iba
%endif

%if %{build_opensm}
%files -n opensm
%defattr(-,root,root)
%{_prefix}/bin/opensm
%{_prefix}/bin/osmtest
%{_prefix}/bin/sldd.sh
%config(noreplace) /etc/opensm.conf
/etc/init.d/opensmd
%{_mandir}/man8/opensm*
%{_mandir}/man8/osmtest*
%endif

%if %{build_perftest}
%files -n perftest
%defattr(-,root,root)
%{_prefix}/bin/ib_rdma_lat
%{_prefix}/bin/ib_rdma_bw
%{_prefix}/bin/ib_write_lat
%{_prefix}/bin/ib_write_bw
%{_prefix}/bin/ib_send_lat
%{_prefix}/bin/ib_send_bw
%{_prefix}/bin/ib_read_lat
%{_prefix}/bin/ib_read_bw
%{_prefix}/bin/runme
%{_prefix}/bin/ib_write_bw_postlist
%{_prefix}/bin/ib_clock_test
%endif

%if %{build_mstflint}
%files -n mstflint
%defattr(-,root,root)
%{_prefix}/bin/mstmread
%{_prefix}/bin/mstflint
%{_prefix}/bin/mstvpd
%{_prefix}/bin/mstregdump
%{_prefix}/bin/mstmwrite
%{_prefix}/include/mtcr.h
%endif

%if %{build_librdmacm}
%files -n librdmacm -f librdmacm-files
%defattr(-,root,root)
%{_libdir}/librdmacm*.so.*
%endif

%if %{build_librdmacm_devel}
%files -n librdmacm-devel -f librdmacm-devel-files
%defattr(-,root,root)
%{_libdir}/librdmacm*.so
%{_prefix}/include/rdma/rdma_cma_abi.h
%{_prefix}/include/rdma/rdma_cma.h
%{_mandir}/man3/rdma_*
%{_mandir}/man7/rdma_*
%endif

%if %{build_librdmacm_utils}
%files -n librdmacm-utils
%defattr(-,root,root)
%{_prefix}/bin/rping
%{_prefix}/bin/ucmatose
%{_prefix}/bin/udaddy
%{_prefix}/bin/mckey
%{_mandir}/man1/rping.1* 
%{_mandir}/man1/ucmatose.1* 
%{_mandir}/man1/udaddy.1* 
%{_mandir}/man1/mckey.1* 
%endif

%if %{build_dapl}
%files -n dapl -f dapl-files
%defattr(-,root,root)
%{_libdir}/libda*.so*
%config(noreplace) /etc/dat.conf
%endif

%if %{build_dapl_devel}
%files -n dapl-devel -f dapl-devel-files
%defattr(-,root,root)
%{_libdir}/libda*.a
%{_prefix}/include/dat/dat.h
%{_prefix}/include/dat/dat_error.h
%{_prefix}/include/dat/dat_platform_specific.h
%{_prefix}/include/dat/dat_redirection.h
%{_prefix}/include/dat/dat_registry.h
%{_prefix}/include/dat/dat_vendor_specific.h
%{_prefix}/include/dat/udat_config.h
%{_prefix}/include/dat/udat.h
%{_prefix}/include/dat/udat_redirection.h
%{_prefix}/include/dat/udat_vendor_specific.h
%endif

%if %{build_dapl_utils}
%files -n dapl-utils
%defattr(-,root,root)
%{_prefix}/bin/dapltest
%{_prefix}/bin/dtest
%{_mandir}/man1/dapltest.1* 
%{_mandir}/man1/dtest.1* 
%endif

%if %{build_libcxgb3}                
%files -n libcxgb3 -f libcxgb3-files
%defattr(-,root,root)
%{_libdir}/libcxgb3*.so
%{_sysconfdir}/libibverbs.d/cxgb3.driver
%endif

%if %{build_libcxgb3_devel}
%files -n libcxgb3-devel -f libcxgb3-devel-files
%defattr(-,root,root)
%{_libdir}/libcxgb3.a
%endif

%if %{build_qlvnictools}
%files -n qlvnictools
%defattr(-,root,root)
%{_prefix}/sbin/ibvexdm
%{_prefix}/sbin/vnic_parser.pl
/etc/init.d/ql_vnic
%endif

%if %{build_sdpnetstat}
%files -n sdpnetstat
%defattr(-,root,root)
%{_prefix}/bin/sdpnetstat
%endif

# END Files

%changelog
* Sun Jan 28 2007 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Created for ofa_user package
